var ws = require("nodejs-websocket");

var rooms = {};

var server = ws.createServer(function (sock) {

	console.log("New connection")

	if (rooms[sock.path])
		rooms[sock.path].push(sock);
	else
		rooms[sock.path] = [sock];

	if (rooms[sock.path].length === 1)
		sock.send('alone');

	sock.on("text", function (txt) {
		for (var i = 0; i < rooms[sock.path].length; i++)
			//if (rooms[sock.path][i] !== sock) // send message to all except the sender socket
				if (rooms[sock.path][i])
					rooms[sock.path][i].send(txt);
				else
					rooms[sock.path].splice(rooms[sock.path].indexOf(rooms[sock.path][i]), 1);

	});

	sock.on("close", function (code, reason) {
		console.log("Connection closed")
		for (var i = 0; i < rooms[sock.path].length; i++)
			if (rooms[sock.path][i] && rooms[sock.path][i] !== sock)
				rooms[sock.path][i].send('one socket closed');

		rooms[sock.path].splice(rooms[sock.path].indexOf(sock), 1);
		delete rooms[sock.path][rooms[sock.path].indexOf(sock)];

		if (rooms[sock.path].length === 1)
			rooms[sock.path][0].send('alone');
	})
}).listen(2607, 'localhost', event => console.log('Server listening ...'));
